/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authz;

import com.floragunn.codova.config.text.Pattern;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.GuiceDependencies;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.legacy.LegacySgConfig;
import com.floragunn.searchguard.authz.ActionAuthorization;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.authz.DocumentWhitelist;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.PrivilegesEvaluationResult;
import com.floragunn.searchguard.authz.RoleBasedActionAuthorization;
import com.floragunn.searchguard.authz.SnapshotRestoreEvaluator;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.authz.config.AuthorizationConfig;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.authz.config.RoleMapping;
import com.floragunn.searchguard.authz.config.Tenant;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ClusterInfoHolder;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.privileges.PrivilegesInterceptor;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContext;
import com.floragunn.searchguard.privileges.SpecialPrivilegesEvaluationContextProviderRegistry;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.StaticSettings;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class PrivilegesEvaluator
implements ComponentStateProvider {
    static final StaticSettings.Attribute<Pattern> ADMIN_ONLY_ACTIONS = StaticSettings.Attribute.define((String)"searchguard.admin_only_actions").withDefault(Pattern.createUnchecked((String)"cluster:admin:searchguard:config/*", (String)"cluster:admin:searchguard:internal/*", (String[])new String[0])).asPattern();
    static final StaticSettings.Attribute<Pattern> ADMIN_ONLY_INDICES = StaticSettings.Attribute.define((String)"searchguard.admin_only_indices").withDefault(Pattern.createUnchecked((String)"searchguard", (String)".searchguard", (String[])new String[]{".searchguard_*", ".signals_watches*", ".signals_accounts", ".signals_settings"})).asPattern();
    static final StaticSettings.Attribute<Boolean> CHECK_SNAPSHOT_RESTORE_WRITE_PRIVILEGES = StaticSettings.Attribute.define((String)"searchguard.check_snapshot_restore_write_privileges").withDefault(true).asBoolean();
    static final StaticSettings.Attribute<Boolean> UNSUPPORTED_RESTORE_SGINDEX_ENABLED = StaticSettings.Attribute.define((String)"searchguard.unsupported.restore.sgindex.enabled").withDefault(false).asBoolean();
    public static final StaticSettings.AttributeSet STATIC_SETTINGS = StaticSettings.AttributeSet.of((StaticSettings.Attribute[])new StaticSettings.Attribute[]{ADMIN_ONLY_ACTIONS, ADMIN_ONLY_INDICES, CHECK_SNAPSHOT_RESTORE_WRITE_PRIVILEGES, UNSUPPORTED_RESTORE_SGINDEX_ENABLED});
    private static final String USER_TENANT = "__user__";
    private static final Logger log = LogManager.getLogger(PrivilegesEvaluator.class);
    protected final Logger actionTrace = LogManager.getLogger((String)"sg_action_trace");
    private final ClusterService clusterService;
    private final AuthorizationService authorizationService;
    private final IndexNameExpressionResolver resolver;
    private final AuditLog auditLog;
    private ThreadContext threadContext;
    private PrivilegesInterceptor privilegesInterceptor;
    private final boolean checkSnapshotRestoreWritePrivileges;
    private final ClusterInfoHolder clusterInfoHolder;
    private final ActionRequestIntrospector actionRequestIntrospector;
    private final SnapshotRestoreEvaluator snapshotRestoreEvaluator;
    private final SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry;
    private final Client localClient;
    private final Pattern adminOnlyActions;
    private final Pattern adminOnlyIndices;
    private final Actions actions;
    private final ComponentState componentState = new ComponentState(10, null, "privileges_evaluator");
    private volatile AuthorizationConfig authzConfig = AuthorizationConfig.DEFAULT;
    private volatile RoleBasedActionAuthorization actionAuthorization = null;
    private String kibanaServerUsername;
    private String kibanaIndexName;
    private volatile boolean kibanaIndexTemplateFixApplied = false;

    public PrivilegesEvaluator(Client localClient, final ClusterService clusterService, ThreadPool threadPool, ConfigurationRepository configurationRepository, AuthorizationService authorizationService, IndexNameExpressionResolver resolver, AuditLog auditLog, final StaticSettings settings, ClusterInfoHolder clusterInfoHolder, final Actions actions, ActionRequestIntrospector actionRequestIntrospector, SpecialPrivilegesEvaluationContextProviderRegistry specialPrivilegesEvaluationContextProviderRegistry, GuiceDependencies guiceDependencies, NamedXContentRegistry namedXContentRegistry, boolean enterpriseModulesEnabled) {
        this.clusterService = clusterService;
        this.resolver = resolver;
        this.auditLog = auditLog;
        this.localClient = localClient;
        this.authorizationService = authorizationService;
        this.threadContext = threadPool.getThreadContext();
        this.checkSnapshotRestoreWritePrivileges = (Boolean)settings.get(CHECK_SNAPSHOT_RESTORE_WRITE_PRIVILEGES);
        this.clusterInfoHolder = clusterInfoHolder;
        this.specialPrivilegesEvaluationContextProviderRegistry = specialPrivilegesEvaluationContextProviderRegistry;
        this.actions = actions;
        this.actionRequestIntrospector = actionRequestIntrospector;
        this.snapshotRestoreEvaluator = new SnapshotRestoreEvaluator(auditLog, guiceDependencies, (Boolean)settings.get(UNSUPPORTED_RESTORE_SGINDEX_ENABLED));
        this.adminOnlyActions = (Pattern)settings.get(ADMIN_ONLY_ACTIONS);
        this.adminOnlyIndices = (Pattern)settings.get(ADMIN_ONLY_INDICES);
        configurationRepository.subscribeOnChange(new ConfigurationChangeListener(){

            @Override
            public void onChange(ConfigMap configMap) {
                SgDynamicConfiguration<AuthorizationConfig> config = configMap.get(CType.AUTHZ);
                SgDynamicConfiguration<LegacySgConfig> legacyConfig = configMap.get(CType.CONFIG);
                AuthorizationConfig authzConfig = AuthorizationConfig.DEFAULT;
                if (config != null && config.getCEntry("default") != null) {
                    authzConfig = config.getCEntry("default");
                    PrivilegesEvaluator.this.authzConfig = authzConfig;
                    log.info("Updated authz config:\n" + config);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)authzConfig);
                    }
                } else if (legacyConfig != null && legacyConfig.getCEntry("sg_config") != null) {
                    try {
                        LegacySgConfig sgConfig = legacyConfig.getCEntry("sg_config");
                        authzConfig = AuthorizationConfig.parseLegacySgConfig(sgConfig.getSource(), null, settings);
                        PrivilegesEvaluator.this.authzConfig = authzConfig;
                        log.info("Updated authz config (legacy):\n" + legacyConfig);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)authzConfig);
                        }
                    }
                    catch (ConfigValidationException e) {
                        log.error("Error while parsing sg_config:\n" + (Object)((Object)e));
                    }
                }
                SgDynamicConfiguration<Role> roles = configMap.get(CType.ROLES);
                SgDynamicConfiguration<Tenant> tenants = configMap.get(CType.TENANTS);
                ActionGroup.FlattenedIndex actionGroups = configMap.get(CType.ACTIONGROUPS) != null ? new ActionGroup.FlattenedIndex(configMap.get(CType.ACTIONGROUPS)) : ActionGroup.FlattenedIndex.EMPTY;
                PrivilegesEvaluator.this.actionAuthorization = new RoleBasedActionAuthorization(roles, actionGroups, actions, clusterService.state().metadata().indices().keySet(), (Set<String>)tenants.getCEntries().keySet(), PrivilegesEvaluator.this.adminOnlyIndices, authzConfig.getMetricsLevel());
                PrivilegesEvaluator.this.componentState.setConfigVersion(configMap.getVersionsAsString());
                PrivilegesEvaluator.this.componentState.replacePart(PrivilegesEvaluator.this.actionAuthorization.getComponentState());
                PrivilegesEvaluator.this.componentState.replacePart(actionGroups.getComponentState());
                PrivilegesEvaluator.this.componentState.updateStateFromParts();
            }
        });
        clusterService.addListener(new ClusterStateListener(){

            public void clusterChanged(ClusterChangedEvent event) {
                RoleBasedActionAuthorization actionAuthorization = PrivilegesEvaluator.this.actionAuthorization;
                if (actionAuthorization != null) {
                    actionAuthorization.updateIndices(event.state().metadata().indices().keySet());
                }
            }
        });
    }

    public boolean isInitialized() {
        return this.actionAuthorization != null;
    }

    public PrivilegesEvaluationResult evaluate(User user, ImmutableSet<String> mappedRoles, String action0, ActionRequest request, Task task, PrivilegesEvaluationContext context, SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext) {
        if (!this.isInitialized()) {
            throw new ElasticsearchSecurityException("Search Guard is not initialized.", new Object[0]);
        }
        if (action0.startsWith("internal:indices/admin/upgrade")) {
            action0 = "indices:admin/upgrade";
        }
        Action action = this.actions.get(action0);
        if (this.adminOnlyActions.matches(action0)) {
            log.info("Action " + action0 + " is reserved for users authenticating with an admin certificate");
            return PrivilegesEvaluationResult.INSUFFICIENT.reason("Action is reserved for users authenticating with an admin certificate").missingPrivileges(action);
        }
        if ("cluster:admin:searchguard:session/_own/delete".equals(action0)) {
            return PrivilegesEvaluationResult.OK;
        }
        if (action.isOpen()) {
            return PrivilegesEvaluationResult.OK;
        }
        AuthorizationConfig authzConfig = this.authzConfig;
        ActionAuthorization actionAuthorization = specialPrivilegesEvaluationContext == null ? this.actionAuthorization : specialPrivilegesEvaluationContext.getActionAuthorization();
        try {
            PrivilegesEvaluationResult result;
            if (request instanceof BulkRequest && Strings.isNullOrEmpty((String)user.getRequestedTenant())) {
                PrivilegesEvaluationResult result2 = actionAuthorization.hasClusterPermission(context, action);
                if (result2.getStatus() != PrivilegesEvaluationResult.Status.OK) {
                    log.info("No cluster-level permission for {} [Action [{}]] [RolesChecked {}]\n{}", (Object)user, (Object)action0, mappedRoles, (Object)result2);
                    return result2;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Taking shortcut for BulkRequest; user: " + user);
                }
                return result2;
            }
            ActionRequestIntrospector.ActionRequestInfo requestInfo = this.actionRequestIntrospector.getActionRequestInfo(action0, request);
            if (log.isDebugEnabled()) {
                if (requestInfo.isUnknown()) {
                    log.debug("### evaluate UNKNOWN " + action0 + " (" + request.getClass().getName() + ")\nUser: " + user + "\nspecialPrivilegesEvaluationContext: " + specialPrivilegesEvaluationContext);
                } else if (!requestInfo.isIndexRequest()) {
                    log.debug("### evaluate " + action0 + " (" + request.getClass().getName() + ")\nUser: " + user + "\nspecialPrivilegesEvaluationContext: " + specialPrivilegesEvaluationContext);
                } else {
                    log.debug("### evaluate " + action0 + " (" + request.getClass().getName() + ")\nUser: " + user + "\nspecialPrivilegesEvaluationContext: " + specialPrivilegesEvaluationContext + "\nResolved: " + requestInfo.getResolvedIndices() + "\nUresolved: " + requestInfo.getUnresolved() + "\nIgnoreUnauthorizedIndices: " + authzConfig.isIgnoreUnauthorizedIndices());
                }
            }
            if (!(result = this.snapshotRestoreEvaluator.evaluate(request, task, action, this.clusterInfoHolder)).isPending()) {
                return result;
            }
            if (action.isClusterPrivilege()) {
                ImmutableSet<Action> additionalPrivileges;
                result = actionAuthorization.hasClusterPermission(context, action);
                if (result.getStatus() != PrivilegesEvaluationResult.Status.OK) {
                    log.info("### No cluster privileges for {} ({})\nUser: {}\nRoles: {}\n{}", (Object)action, (Object)request.getClass().getName(), (Object)user, mappedRoles, (Object)result);
                    return result;
                }
                if (request instanceof RestoreSnapshotRequest && this.checkSnapshotRestoreWritePrivileges) {
                    return this.evaluateIndexPrivileges(user, action0, action.expandPrivileges(request), request, task, requestInfo, mappedRoles, authzConfig, actionAuthorization, specialPrivilegesEvaluationContext, context);
                }
                if (this.privilegesInterceptor != null) {
                    PrivilegesInterceptor.InterceptionResult replaceResult = this.privilegesInterceptor.replaceKibanaIndex(context, request, action, actionAuthorization);
                    if (log.isDebugEnabled()) {
                        log.debug("Result from privileges interceptor for cluster perm: {}", (Object)replaceResult);
                    }
                    if (replaceResult == PrivilegesInterceptor.InterceptionResult.DENY) {
                        this.auditLog.logMissingPrivileges(action0, (TransportRequest)request, task);
                        return PrivilegesEvaluationResult.INSUFFICIENT.reason("Denied due to multi-tenancy settings");
                    }
                    if (replaceResult == PrivilegesInterceptor.InterceptionResult.ALLOW) {
                        return PrivilegesEvaluationResult.OK;
                    }
                }
                if ((additionalPrivileges = action.getAdditionalPrivileges(request)).isEmpty()) {
                    if (log.isTraceEnabled()) {
                        log.trace("Allowing as cluster privilege: " + action0);
                    }
                    return PrivilegesEvaluationResult.OK;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Additional privileges required: " + additionalPrivileges);
                }
                return this.evaluateAdditionalPrivileges(user, action0, additionalPrivileges, request, task, requestInfo, mappedRoles, authzConfig, actionAuthorization, specialPrivilegesEvaluationContext, context);
            }
            if (action.isTenantPrivilege()) {
                result = this.hasTenantPermission(user, mappedRoles, action, actionAuthorization, context);
                if (!result.isOk()) {
                    log.info("No {}-level perm match for {} {} [Action [{}]] [RolesChecked {}]:\n{}", (Object)"tenant", (Object)user, (Object)requestInfo, (Object)action0, mappedRoles, (Object)result);
                    return result;
                }
                if (log.isTraceEnabled()) {
                    log.trace("Allowing as tenant privilege: " + action0);
                }
                return result;
            }
            if (this.checkDocWhitelistHeader(user, action0, request)) {
                if (log.isTraceEnabled()) {
                    log.trace("Allowing due to doc whitelist: " + action0);
                }
                return PrivilegesEvaluationResult.OK;
            }
            ImmutableSet<Action> allIndexPermsRequired = action.expandPrivileges(request);
            if (log.isDebugEnabled() && (allIndexPermsRequired.size() > 1 || !allIndexPermsRequired.contains((Object)action))) {
                log.debug("Expanded index privileges: " + allIndexPermsRequired);
            }
            return this.evaluateIndexPrivileges(user, action0, allIndexPermsRequired, request, task, requestInfo, mappedRoles, authzConfig, actionAuthorization, specialPrivilegesEvaluationContext, context);
        }
        catch (Exception e) {
            log.error("Error while evaluating " + action0 + " (" + request.getClass().getName() + ")", (Throwable)e);
            return PrivilegesEvaluationResult.INSUFFICIENT.with((ImmutableList<PrivilegesEvaluationResult.Error>)ImmutableList.of((Object)new PrivilegesEvaluationResult.Error(e.getMessage(), e)));
        }
    }

    private PrivilegesEvaluationResult evaluateIndexPrivileges(User user, String action0, ImmutableSet<Action> requiredPermissions, ActionRequest request, Task task, ActionRequestIntrospector.ActionRequestInfo actionRequestInfo, ImmutableSet<String> mappedRoles, AuthorizationConfig authzConfig, ActionAuthorization actionAuthorization, SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext, PrivilegesEvaluationContext context) throws PrivilegesEvaluationException {
        boolean dnfofPossible;
        ActionFilter additionalActionFilter = null;
        if (actionRequestInfo.getResolvedIndices().containsOnlyRemoteIndices()) {
            log.debug("Request contains only remote indices. We can skip all further checks and let requests be handled by remote cluster: " + action0);
            return PrivilegesEvaluationResult.OK;
        }
        if (log.isDebugEnabled()) {
            log.debug("requested resolved indextypes: {}", (Object)actionRequestInfo);
        }
        if (!this.kibanaIndexTemplateFixApplied && user.getName().equals(this.kibanaServerUsername) && (request instanceof ResizeRequest && ((ResizeRequest)request).getSourceIndex().startsWith(this.kibanaIndexName) && ((ResizeRequest)request).getSourceIndex().endsWith("_reindex_temp") || request instanceof CreateIndexRequest && ((CreateIndexRequest)request).index().startsWith(this.kibanaIndexName))) {
            this.kibanaIndexTemplateFixApplied = true;
            IndexTemplateMetadata template = (IndexTemplateMetadata)this.clusterService.state().getMetadata().getTemplates().get((Object)"tenant_template");
            if (template != null && template.patterns().size() > 0 && ((String)template.patterns().get(0)).startsWith(this.kibanaIndexName)) {
                additionalActionFilter = new ActionFilter(){

                    public int order() {
                        return 0;
                    }

                    public <Request extends ActionRequest, Response extends ActionResponse> void apply(final Task task, final String action, final Request request, final ActionListener<Response> listener, final ActionFilterChain<Request, Response> chain) {
                        PrivilegesEvaluator.this.localClient.admin().indices().deleteTemplate(new DeleteIndexTemplateRequest("tenant_template"), (ActionListener)new ActionListener<AcknowledgedResponse>(){

                            public void onResponse(AcknowledgedResponse response) {
                                log.info("Deleted obsolete tenant_template");
                                chain.proceed(task, action, request, listener);
                            }

                            public void onFailure(Exception e) {
                                log.error("Error while deleting tenant_template. Ignoring.", (Throwable)e);
                                chain.proceed(task, action, request, listener);
                            }
                        });
                    }
                };
            }
        }
        if (this.privilegesInterceptor != null) {
            PrivilegesInterceptor.InterceptionResult replaceResult = this.privilegesInterceptor.replaceKibanaIndex(context, request, this.actions.get(action0), actionAuthorization);
            if (log.isDebugEnabled()) {
                log.debug("Result from privileges interceptor: {}", (Object)replaceResult);
            }
            if (replaceResult == PrivilegesInterceptor.InterceptionResult.DENY) {
                this.auditLog.logMissingPrivileges(action0, (TransportRequest)request, task);
                return PrivilegesEvaluationResult.INSUFFICIENT.reason("Denied due to multi-tenancy settings");
            }
            if (replaceResult == PrivilegesInterceptor.InterceptionResult.ALLOW) {
                return PrivilegesEvaluationResult.OK.with(additionalActionFilter);
            }
        }
        boolean bl = dnfofPossible = authzConfig.isIgnoreUnauthorizedIndices() && authzConfig.getIgnoreUnauthorizedIndicesActions().matches(action0) && (actionRequestInfo.ignoreUnavailable() || actionRequestInfo.containsWildcards());
        if (!dnfofPossible) {
            context.setResolveLocalAll(false);
        }
        ImmutableSet allIndexPermsRequired = requiredPermissions.matching(Action::isIndexPrivilege);
        ImmutableSet clusterPermissions = requiredPermissions.matching(Action::isClusterPrivilege);
        if (!clusterPermissions.isEmpty()) {
            for (Action clusterPermission : clusterPermissions) {
                PrivilegesEvaluationResult result = actionAuthorization.hasClusterPermission(context, clusterPermission);
                if (result.getStatus() == PrivilegesEvaluationResult.Status.OK) continue;
                if (log.isEnabled(Level.INFO)) {
                    log.info("### No cluster privileges for " + clusterPermission + " (" + request.getClass().getName() + ")\nUser: " + user + "\nResolved Indices: " + actionRequestInfo.getResolvedIndices() + "\nUnresolved: " + actionRequestInfo.getUnresolved() + "\nRoles: " + mappedRoles + "\n" + result);
                }
                return result;
            }
        }
        PrivilegesEvaluationResult privilegesEvaluationResult = actionAuthorization.hasIndexPermission(context, (ImmutableSet<Action>)allIndexPermsRequired, actionRequestInfo.getResolvedIndices());
        if (log.isTraceEnabled()) {
            log.trace("Result from privileges evaluation: " + (Object)((Object)privilegesEvaluationResult.getStatus()) + "\n" + privilegesEvaluationResult);
        }
        if (privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.PARTIALLY_OK) {
            if (dnfofPossible) {
                if (log.isDebugEnabled()) {
                    log.debug("DNF: Reducing indices to " + privilegesEvaluationResult.getAvailableIndices() + "\n" + privilegesEvaluationResult);
                }
                privilegesEvaluationResult = this.actionRequestIntrospector.reduceIndices(action0, request, (Set<String>)privilegesEvaluationResult.getAvailableIndices(), actionRequestInfo);
            } else {
                privilegesEvaluationResult = privilegesEvaluationResult.status(PrivilegesEvaluationResult.Status.INSUFFICIENT);
            }
        } else if (privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.INSUFFICIENT && dnfofPossible) {
            if (!actionRequestInfo.getResolvedIndices().getRemoteIndices().isEmpty()) {
                privilegesEvaluationResult = this.actionRequestIntrospector.reduceIndices(action0, request, (Set<String>)ImmutableSet.empty(), actionRequestInfo);
            } else if (authzConfig.getIgnoreUnauthorizedIndicesActionsAllowingEmptyResult().matches(action0)) {
                if (log.isTraceEnabled()) {
                    log.trace("Changing result from INSUFFICIENT to EMPTY");
                }
                privilegesEvaluationResult = privilegesEvaluationResult.status(PrivilegesEvaluationResult.Status.EMPTY);
            }
        }
        if (privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.EMPTY) {
            if (this.actionRequestIntrospector.forceEmptyResult(request)) {
                if (log.isDebugEnabled()) {
                    log.debug("DNF: Reducing indices to yield an empty result\n" + privilegesEvaluationResult);
                }
                privilegesEvaluationResult = privilegesEvaluationResult.status(PrivilegesEvaluationResult.Status.OK);
            } else {
                log.warn("DNFOF for empty results is not available for " + action0 + " (" + request.getClass().getName() + ")");
            }
        }
        if (privilegesEvaluationResult.getStatus() != PrivilegesEvaluationResult.Status.OK) {
            Level logLevel;
            Level level = logLevel = privilegesEvaluationResult.hasErrors() ? Level.WARN : Level.INFO;
            if (log.isEnabled(logLevel)) {
                log.log(logLevel, "### No index privileges for " + action0 + " (" + request.getClass().getName() + ")\nUser: " + user + "\nResolved Indices: " + actionRequestInfo.getResolvedIndices() + "\nUnresolved: " + actionRequestInfo.getUnresolved() + "\nRoles: " + mappedRoles + "\nRequired Privileges: " + allIndexPermsRequired + "\n" + privilegesEvaluationResult);
            }
            return privilegesEvaluationResult;
        }
        if (request instanceof ResizeRequest) {
            ResizeRequest resizeRequest;
            CreateIndexRequest createIndexRequest;
            PrivilegesEvaluationResult subResponse;
            if (log.isDebugEnabled()) {
                log.debug("Checking additional create index action for resize operation: " + request);
            }
            if (!(subResponse = this.evaluate(user, mappedRoles, "indices:admin/create", (ActionRequest)(createIndexRequest = (resizeRequest = (ResizeRequest)request).getTargetIndexRequest()), task, context, specialPrivilegesEvaluationContext)).isOk()) {
                return subResponse;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Allowed because we have all indices permissions for " + allIndexPermsRequired);
        }
        return PrivilegesEvaluationResult.OK;
    }

    private PrivilegesEvaluationResult evaluateAdditionalPrivileges(User user, String action0, ImmutableSet<Action> additionalPrivileges, ActionRequest request, Task task, ActionRequestIntrospector.ActionRequestInfo actionRequestInfo, ImmutableSet<String> mappedRoles, AuthorizationConfig authzConfig, ActionAuthorization actionAuthorization, SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext, PrivilegesEvaluationContext context) throws PrivilegesEvaluationException {
        if (additionalPrivileges.forAllApplies(a -> a.isIndexPrivilege())) {
            return this.evaluateIndexPrivileges(user, action0, additionalPrivileges, request, task, actionRequestInfo, mappedRoles, authzConfig, actionAuthorization, specialPrivilegesEvaluationContext, context);
        }
        ImmutableSet indexPrivileges = ImmutableSet.empty();
        for (Action action : additionalPrivileges) {
            PrivilegesEvaluationResult result;
            if (action.isClusterPrivilege()) {
                result = actionAuthorization.hasClusterPermission(context, action);
                if (result.getStatus() == PrivilegesEvaluationResult.Status.OK) continue;
                log.info("Additional privilege missing: " + result);
                return result;
            }
            if (action.isTenantPrivilege()) {
                result = this.hasTenantPermission(user, mappedRoles, action, actionAuthorization, context);
                if (result.getStatus() == PrivilegesEvaluationResult.Status.OK) continue;
                log.info("Additional privilege missing: " + result);
                return result;
            }
            if (!action.isIndexPrivilege()) continue;
            indexPrivileges = indexPrivileges.with((Object)action);
        }
        if (!indexPrivileges.isEmpty()) {
            return this.evaluateIndexPrivileges(user, action0, (ImmutableSet<Action>)indexPrivileges, request, task, actionRequestInfo, mappedRoles, authzConfig, actionAuthorization, specialPrivilegesEvaluationContext, context);
        }
        if (log.isTraceEnabled()) {
            log.trace("Allowing: " + action0);
        }
        return PrivilegesEvaluationResult.OK;
    }

    public Set<String> getAllConfiguredTenantNames() {
        return this.actionAuthorization.getTenants();
    }

    public boolean multitenancyEnabled() {
        return this.privilegesInterceptor != null && this.privilegesInterceptor.isEnabled();
    }

    public String getKibanaServerUser() {
        return this.privilegesInterceptor != null ? this.privilegesInterceptor.getKibanaServerUser() : "kibanaserver";
    }

    public String getKibanaIndex() {
        return this.privilegesInterceptor != null ? this.privilegesInterceptor.getKibanaIndex() : null;
    }

    public boolean notFailOnForbiddenEnabled() {
        return this.authzConfig.isIgnoreUnauthorizedIndices();
    }

    public static boolean isTenantPerm(String action0) {
        return action0.startsWith("cluster:admin:searchguard:tenant:");
    }

    public Map<String, Boolean> mapTenants(User user, Set<String> roles) {
        return this.privilegesInterceptor != null ? this.privilegesInterceptor.mapTenants(user, (ImmutableSet<String>)ImmutableSet.of(roles), this.actionAuthorization) : ImmutableMap.empty();
    }

    public Map<String, Boolean> evaluateClusterAndTenantPrivileges(User user, TransportAddress caller, Collection<String> privilegesAskedFor) {
        if (privilegesAskedFor == null || privilegesAskedFor.isEmpty() || user == null) {
            log.debug("Privileges or user empty");
            return Collections.emptyMap();
        }
        ImmutableSet<String> mappedRoles = this.authorizationService.getMappedRoles(user, caller);
        String requestedTenant = this.getRequestedTenant(user);
        PrivilegesEvaluationContext context = new PrivilegesEvaluationContext(user, mappedRoles, null, null, this.authzConfig.isDebugEnabled(), this.actionRequestIntrospector, null);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        boolean tenantValid = this.isTenantValid(requestedTenant);
        if (!tenantValid) {
            log.info("Invalid tenant: " + requestedTenant + "; user: " + user);
        }
        for (String privilegeAskedFor : privilegesAskedFor) {
            Action action = this.actions.get(privilegeAskedFor);
            try {
                PrivilegesEvaluationResult privilegesEvaluationResult;
                if (action.isTenantPrivilege()) {
                    if (tenantValid) {
                        privilegesEvaluationResult = this.actionAuthorization.hasTenantPermission(context, action, requestedTenant);
                        result.put(privilegeAskedFor, privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.OK);
                        continue;
                    }
                    result.put(privilegeAskedFor, false);
                    continue;
                }
                privilegesEvaluationResult = this.actionAuthorization.hasClusterPermission(context, action);
                result.put(privilegeAskedFor, privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.OK);
            }
            catch (PrivilegesEvaluationException e) {
                log.error("Error while evaluating " + privilegeAskedFor + " for " + user, (Throwable)e);
                result.put(privilegeAskedFor, false);
            }
        }
        return result;
    }

    private boolean isTenantValid(String requestedTenant) {
        if ("SGS_GLOBAL_TENANT".equals(requestedTenant) || USER_TENANT.equals(requestedTenant)) {
            return true;
        }
        return this.getAllConfiguredTenantNames().contains(requestedTenant);
    }

    private PrivilegesEvaluationResult hasTenantPermission(User user, ImmutableSet<String> mappedRoles, Action action, ActionAuthorization actionAuthorization, PrivilegesEvaluationContext context) throws PrivilegesEvaluationException {
        String requestedTenant;
        String string = requestedTenant = !Strings.isNullOrEmpty((String)user.getRequestedTenant()) ? user.getRequestedTenant() : "SGS_GLOBAL_TENANT";
        if (!this.multitenancyEnabled() && !"SGS_GLOBAL_TENANT".equals(requestedTenant)) {
            log.warn("Denying request to non-default tenant because MT is disabled: " + requestedTenant);
            return PrivilegesEvaluationResult.INSUFFICIENT.reason("Multi-tenancy is disabled");
        }
        return actionAuthorization.hasTenantPermission(context, action, requestedTenant);
    }

    private String getRequestedTenant(User user) {
        String requestedTenant = user.getRequestedTenant();
        if (Strings.isNullOrEmpty((String)requestedTenant) || !this.multitenancyEnabled()) {
            return "SGS_GLOBAL_TENANT";
        }
        return requestedTenant;
    }

    public boolean hasClusterPermission(User user, String actionName, TransportAddress callerTransportAddress) throws PrivilegesEvaluationException {
        ActionAuthorization actionAuthorization;
        ImmutableSet<String> mappedRoles;
        SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext = this.specialPrivilegesEvaluationContextProviderRegistry.provide(user, this.threadContext);
        if (specialPrivilegesEvaluationContext != null) {
            user = specialPrivilegesEvaluationContext.getUser();
        }
        if (specialPrivilegesEvaluationContext == null) {
            mappedRoles = this.authorizationService.getMappedRoles(user, callerTransportAddress);
            actionAuthorization = this.actionAuthorization;
        } else {
            mappedRoles = specialPrivilegesEvaluationContext.getMappedRoles();
            actionAuthorization = specialPrivilegesEvaluationContext.getActionAuthorization();
        }
        Action action = this.actions.get(actionName);
        PrivilegesEvaluationContext context = new PrivilegesEvaluationContext(user, mappedRoles, action, null, this.authzConfig.isDebugEnabled(), this.actionRequestIntrospector, specialPrivilegesEvaluationContext);
        PrivilegesEvaluationResult privilegesEvaluationResult = actionAuthorization.hasClusterPermission(context, action);
        return privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.OK;
    }

    public boolean hasClusterPermissions(User user, List<String> permissions, TransportAddress callerTransportAddress) throws PrivilegesEvaluationException {
        ActionAuthorization actionAuthorization;
        ImmutableSet<String> mappedRoles;
        if (permissions.isEmpty()) {
            return true;
        }
        SpecialPrivilegesEvaluationContext specialPrivilegesEvaluationContext = this.specialPrivilegesEvaluationContextProviderRegistry.provide(user, this.threadContext);
        if (specialPrivilegesEvaluationContext != null) {
            user = specialPrivilegesEvaluationContext.getUser();
        }
        if (specialPrivilegesEvaluationContext == null) {
            mappedRoles = this.authorizationService.getMappedRoles(user, callerTransportAddress);
            actionAuthorization = this.actionAuthorization;
        } else {
            mappedRoles = specialPrivilegesEvaluationContext.getMappedRoles();
            actionAuthorization = specialPrivilegesEvaluationContext.getActionAuthorization();
        }
        PrivilegesEvaluationContext context = new PrivilegesEvaluationContext(user, mappedRoles, null, null, this.authzConfig.isDebugEnabled(), this.actionRequestIntrospector, null);
        for (String permission : permissions) {
            PrivilegesEvaluationResult privilegesEvaluationResult = actionAuthorization.hasClusterPermission(context, this.actions.get(permission));
            if (privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.OK) continue;
            return false;
        }
        return true;
    }

    public boolean hasClusterPermissions(String permission, PrivilegesEvaluationContext context) throws PrivilegesEvaluationException {
        ActionAuthorization actionAuthorization = context.getSpecialPrivilegesEvaluationContext() == null ? this.actionAuthorization : context.getSpecialPrivilegesEvaluationContext().getActionAuthorization();
        PrivilegesEvaluationResult privilegesEvaluationResult = actionAuthorization.hasClusterPermission(context, this.actions.get(permission));
        return privilegesEvaluationResult.getStatus() == PrivilegesEvaluationResult.Status.OK;
    }

    private boolean checkDocWhitelistHeader(User user, String action, ActionRequest request) {
        String docWhitelistHeader = this.threadContext.getHeader("_sg_doc_whitelist");
        if (docWhitelistHeader == null) {
            return false;
        }
        if (!(request instanceof GetRequest)) {
            return false;
        }
        try {
            DocumentWhitelist documentWhitelist = DocumentWhitelist.parse(docWhitelistHeader);
            GetRequest getRequest = (GetRequest)request;
            if (documentWhitelist.isWhitelisted(getRequest.index(), getRequest.id())) {
                if (log.isDebugEnabled()) {
                    log.debug("Request " + request + " is whitelisted by " + documentWhitelist);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("Error while handling document whitelist: " + docWhitelistHeader, (Throwable)e);
            return false;
        }
    }

    public PrivilegesInterceptor getPrivilegesInterceptor() {
        return this.privilegesInterceptor;
    }

    public void setPrivilegesInterceptor(PrivilegesInterceptor privilegesInterceptor) {
        this.privilegesInterceptor = privilegesInterceptor;
    }

    public RoleBasedActionAuthorization getActionAuthorization() {
        return this.actionAuthorization;
    }

    public RoleMapping.ResolutionMode getRolesMappingResolution() {
        return this.authzConfig.getRoleMappingResolution();
    }

    public ActionGroup.FlattenedIndex getActionGroups() {
        return this.actionAuthorization.getActionGroups();
    }

    public ClusterService getClusterService() {
        return this.clusterService;
    }

    public IndexNameExpressionResolver getResolver() {
        return this.resolver;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    public boolean isDebugEnabled() {
        return this.authzConfig.isDebugEnabled();
    }
}

